function [Fmax,zmax,zest,sigma0] = zcalibrate(Fest,sigmaz,ztrue)
% This function is to calibrate parameters for the axial position estimation.

% (C) Copyright 2018
% All rights reserved
% Department of Imaging Physics
% Faculty of Applied Sciences
% Delft University of Technology
% Delft, The Netherlands   

% fit model S-curve to fitted values for S-curve
Fmaxstart = 0.8;
rico = mean(Fest.*ztrue)/mean(ztrue.^2);
zmaxstart = 2*Fmaxstart/rico;
if zmaxstart>0
  zdown = zmaxstart/10;
  zup = 10*zmaxstart;
else
  zdown = 10*zmaxstart;
  zup = zmaxstart/10;
end
fo = fitoptions('Method','NonlinearLeastSquares',...
               'Lower',[-1.0,zdown],...
               'Upper',[1.0,zup],...
               'StartPoint',[Fmaxstart zmaxstart]);
ft = fittype('2*Fmax*(x/zmax)/(1+(x/zmax)^2)','options',fo);
fitcurve = fit(ztrue,Fest,ft);
Fmax = fitcurve.Fmax;
zmax = fitcurve.zmax;
Ffit = 2*Fmax*(ztrue/zmax)./(1+(ztrue/zmax).^2);

% get estimated z-positions and nominal spot sizes
Fest = min(Fest,Fmax);
Fest = max(Fest,-Fmax);
zest = zmax*Fest./(Fmax+sqrt(Fmax^2-Fest.^2));
sigma0 = sigmaz*sqrt(1-Fmax^2)./sqrt(1+zest.^2/zmax^2);
      
% make plot
figure
subplot(1,2,1)
hold on
box on
plot(ztrue,Fest,'or')
plot(ztrue,Ffit,'sb')
legend('data','fit','Location','NorthWest')
xlabel('ground truth z [nm]')
ylabel('focus S-curve')

% find nominal spot size
xs = 1+ztrue.^2/zmax^2;
ys = (1-Fmax^2)*sigmaz.^2;
sigma0mean = sqrt(mean(ys.*xs)/mean(xs.^2));
sigmazfit = sigma0mean*sqrt(xs/(1-Fmax^2));

subplot(1,2,2)
hold on
box on
plot(ztrue,sigmaz,'or')
plot(ztrue,sigmazfit,'sb')
legend('data','fit','Location','North')
xlabel('ground truth z [nm]')
ylabel('spot width [\lambda/NA]')

end

